<?xml version="1.0" encoding="UTF-8"?>
<!-- 
  Schematron als Ergänzung zur KIS DTD 2.3
  Patrick Schwarz, (c) 2013 Georg Thieme Verlag KG Stuttgart
  Features: 
    Linkcheck, Abbildungsprüfung, Section ohne Titel
  Changelog:
    v0.1 initial release, ps, 15.03.2012
    v1.0, aufgeräumt, Prüfung im Images- und Rootordner, Check für alte Boxtypen und leere Elemente
    v1.1, 24.08.12 Dateipfad für Abbildungsprüfugn umgestellt, da nicht mehr funktionsfähig
    v1.2, 29.11.12 Links ohne id aufzählen; Prüfung Datumsangaben, ISBN-Nummer, Materialnummer; URL-Filter gegen Schematron-Abbruch bei Sonderzeichen (Abb.)
    v1.3, 14.12.12 Neues Metadatenmodell ergänzt
    v1.4, 07.01.13 Warnungen und Fehler korrigiert
    v1.5, 04.02.13 Formulierung, empty Element Prüfung korrigiert
    v1.6, 25.02.13 Prüfregeln für Tabellen, externe Links, x-Level, leere Dateinamen in Abbildungen, Section-Titellänge
    v1.7, 20.03.13 Prüfung nach mehrfach gesetzten meta-Elementen, Prüfung nach unnötigen emphs
    v1.8, 11.04.13 Bugfix Section-Titellänge und uri-Prüfung, Deprecated-Elemente
    v1.9, 10.07.13 Keine figure,box,table in listing; para beginnt mit Leerzeichen; Absatzprüfung; Tabellenkopfzeile; Listenebenen; Sectionabsatz (Lu)
-->
<schema xmlns="http://purl.oclc.org/dsdl/schematron" see="http://wiki.medionet.de/Thieme/4._Oxygen/Schematron" queryBinding="xslt2" xml:lang="de-DE">
    <let name="version" value="'kiSCHeck-23, v1.9-10.07.13'"/>
    <let name="dir_fileref" value="'images/'"/>
    <ns uri="java:java.io.File" prefix="f"/>
    <ns uri="java:java.net.URI" prefix="u"/>
    <title>KIS DTD 2.3 Schematron</title>

    <!-- Infomeldungen -->
    <pattern id="info">
        <rule context="/" role="Versionsinfo und Statistik">
            <report test="." role="info">
                <value-of select="concat('=== ',current-dateTime(),': Processing ',base-uri(),' with ', $version,' ===')"/>
            </report>
            <report test="." role="info">
                <value-of select="concat('[Statistik] Links: ',count(//link[@idref = //@id]),' valide + ',count(//link/@idref) - count(//link[@idref = //@id]),' invalide + ',count(//link[not(@idref)]),' leer = ',count(//link),' gesamt')"/>
            </report>
            <report test="." role="info">
                <value-of select="concat('[Statistik] Linkziele: ',count(//@id[. = //link/@idref]),' genutzt + ',count(//@id) - count(//@id[. = //link/@idref]),' ungenutzt = ',count(//@id),' gesamt')"/>
            </report>
            <report test="." role="info">
                <value-of select="concat('[Statistik] Abbildungen: ',count(//@fileref[not(f:exists(f:new(resolve-uri(concat($dir_fileref,replace(., '[^a-zA-Z0-9_\-. ]','')), base-uri())))) and not(f:exists(f:new(resolve-uri(replace(., '[^a-zA-Z0-9_\-. ]',''), base-uri()))))]),' von ',count(//graphic),' fehlen, davon ',count(//graphic[@fileref='']),' leer')"/>
            </report>
        </rule>
    </pattern>
    
    <!-- Metadaten prüfen -->
    <pattern id="metadata">
        <rule context="meta/*" role="Gültigkeit der Metadaten prüfen">
            <let name="name" value="name()"/>
            <let name="type" value="@type"/>
            <report test=".[count(parent::*/*[name()=$name and @type=$type])>1]">Das Element <name/> mit dem Attributwert <value-of select="@type"/> ist mehrfach gesetzt.</report>
            <report test=".[count(parent::*/*[name()=$name and not(@type)])>1]">Das Element <name/> ist mehrfach gesetzt.</report>
        </rule>
    </pattern>
    
    <!-- Nummern prüfen -->
    <pattern id="numbers">
        <rule context="materialID | materialid" role="Gültigkeit der Materialnummer prüfen">
            <report test=". = '1234560101'" role="warn">Die Materialnummer ist ungültig</report>
            <assert test="matches(., '^[0-9]{6,10}$') or string-length(.) = 0">Die Materialnummer muss aus einer 6-10 stelligen Zahl bestehen</assert>
        </rule>
        <rule context="isbn" role="Gültigkeit der ISBN-Nummer prüfen">
            <let name="checksum" value="number(substring(., string-length(), 1))"/>
            <let name="digits" value="for $i in reverse(string-to-codepoints(substring(., 1, string-length() -1))) return $i - 48"/>
            <let name="calculation" value="sum((for $i in $digits[(position()) mod 2 = 1] return $i * 3, for $i in $digits[(position()) mod 2 = 0] return $i)) mod 10"/>
            <report test="string-length(.) ne 13 or (if ($calculation ne 0) then (10 - $calculation) else 0) ne $checksum" role="warn">Die ISBN-Nummer ist ungültig</report>
            <let name="value" value="."/>
            <report test="count(//isbn[text()=$value]) > 1" role="warn">Es sind mehrere ISBN mit gleicher Nummer definiert</report>
        </rule>
        <rule context="publicationDate | creationDate | dateSubmitted | dateAccepted | dateModified | dateReleased | docdate" role="Gültigkeit des Datums prüfen">
            <assert test="matches(., '^([\d]{4})-(1[0-2]|0[1-9])-(3[0-1]|0[1-9]|[1-2][\d])$')" role="warn">Das Datum ist ungültig</assert>
        </rule>
    </pattern>

    <!-- Verlinkungen prüfen -->
    <pattern see="http://wiki.medionet.de/Thieme/3._XML_Grundlagen/Verlinkungen" id="links">
        <rule context="link/@idref" role="Linkquellen ohne Ziele aufzählen">
            <assert test=". = //node()/@id" role="warn">Link <value-of select="."/> hat kein gültiges Ziel</assert>
        </rule>
        <rule context="link[not(@idref) and not(@cmid)]" role="Linkquellen ohne id aufzählen">
            <report test="." role="warn">Link <value-of select="."/> hat keine Zieldefinition</report>
        </rule>
        <rule context="target/@id" role="Linkziele ohne Quellen aufzählen">
            <assert test=". = //link/@idref" role="info">Ziel <value-of select="."/> ist ungenutzt</assert>
        </rule>
        <rule context="@href[not(../@type='email')]" role="Gültigkeit der Weblinks prüfen">
            <assert test="matches(.,'^(https?|ftp)://[^\s/$.?#].[^\s]*$')">Die angegebene URL ist nicht zulässig</assert>
        </rule>
        <rule context="@href[../@type='email']" role="Gültigkeit der E-Mail-Links prüfen">
            <assert test="matches(.,'^[^0-9][a-zA-Z0-9_\-]*([.][a-zA-Z0-9_\-]+)*[@][a-zA-Z0-9_\-]+([.][a-zA-Z0-9_\-]+)*[.][a-zA-Z]{2,4}$')">Die angegebene E-Mail ist nicht zulässig</assert>
        </rule>
        <rule context="para/text() | emph/text() | footnote/text() | literature/text()" role="Nicht getaggte Links aufspüren">
            <report role="warn" test="contains(.,'www.')">Möglicherweise ist in diesem Absatz eine URL nicht verlinkt.</report>
            <report role="warn" test="contains(.,'@')">Möglicherweise ist in diesem Absatz eine E-Mail nicht verlinkt.</report>
        </rule>
    </pattern>

    <!-- Abbildungsprüfung -->
    <pattern see="http://wiki.medionet.de/Thieme/Oxygen/Abbildungen" id="figures">
        <rule context="@fileref" role="Gültigkeit der Abbildungslinks prüfen">
            <let name="file" value="f:new(resolve-uri(replace(., '[^a-zA-Z0-9_\-. ]',''), base-uri()))"/>
            <let name="file2" value="f:new(resolve-uri(concat($dir_fileref,replace(., '[^a-zA-Z0-9_\-. ]','')), base-uri()))"/>
            <report test="matches(., '[^a-zA-Z0-9_\-. ]')">Die Abbildung <value-of select="."/> enthält Sonderzeichen und kann nicht geprüft werden</report>
            <report test="matches(., '[A-Z ]')" role="warn">Die Abbildung <value-of select="."/> sollte keine Leerzeichen oder Großbuchstaben enthalten</report>
            <assert test="string-length() > 0">Eine Abbildung hat keinen Dateinamen</assert>
            <assert test="f:exists($file) or f:exists($file2)" role="warn"> Abbildung <value-of select="."/> fehlt</assert>
        </rule>
    </pattern>

    <!-- Tabellenprüfung (ignoriert rowspan-Tabellen) -->
    <pattern see="http://wiki.medionet.de/Thieme/3._XML_Grundlagen/Tabellen" id="tables">
        <rule context="table[not(.//@rowspan)]/.//tr" see="http://wiki.medionet.de/Thieme/3._XML_Grundlagen/Tabellen#Spaltenbreiten" role="Colspan-Überprüfung bei Tabellen">
            <assert test="number(count(*[not(@colspan)])+sum(.//@colspan)) = number(count(../..//col))">Die Anzahl der Spalten stimmt nicht mit den col-Werten überein</assert>
        </rule>
        <rule context="table" role="Prüfung auf Kopfzeile">
            <assert role="warn" test="thead">Die Tabelle hat keine Kopfzeile</assert>
        </rule>
    </pattern>

    <!-- Boxen überprüfen -->
    <pattern id="boxes">
        <rule context="box" role="Fehlerhafte Boxen">
            <assert role="info" test="title">Diese Box hat keinen Titel</assert>
            <report role="warn" test="starts-with(@type, 'H')" see="http://wiki.medionet.de/Thieme/2._TReX_Word/Boxen%3a_Eine_%c3%9cbersicht">Sie benutzen veraltete Box-Typen</report>
        </rule>
    </pattern>
    
    <!-- Leere Elemente -->
    <pattern id="emptyelements">
        <rule context="para | title | shorttitle" role="Elemente mit umgebendem Whitespace">
            <assert role="warn" test="normalize-space(text()) = text()"><name/> enthält Leerzeichen zu Beginn oder am Ende des Elements</assert>
        </rule>
        <rule context="node() [not(name()='br') and not(name()='graphic') and not(name()='audio') and not(name()='video') and not(name()='col') and not(name()='target') and not(name()='concept') and not(name()='custom')]" role="Leere Elemente auffinden">
            <report role="info" test="string-length(normalize-space(.)) = 0 and not(*)">Leeres Element <value-of select="name(.)"/></report>
        </rule>
        
    </pattern>
    
    <!-- Auszeichnungen -->
    <pattern id="emphasis">
        <rule context="emph" role="Prüfung der Auszeichnungen">
            <report role="warn" test=".[following-sibling::node()[1][name()='emph' and @type=preceding-sibling::*[1]/@type]]">An dieser Stelle können mehrere Auszeichnungen zusammengeführt werden</report>
            <report role="warn" test="string-length(normalize-space())=0">Es ist ein Auszeichnungselement ohne Inhalt gesetzt</report>
        </rule>
    </pattern>
    
    <!-- x-level -->
    <pattern id="xlevel">
        <rule context="section[@level='x']" role="Prüfung des x-Levels">
            <report test=".//section[@level='x']">Das x-Level darf in einem Hierarchiepfad nur einmal verwendet werden</report>
        </rule>
    </pattern>
    
    <!-- title-Prüfung -->
    <pattern id="title">
        <rule context="section[count(ancestor-or-self::section) &lt; 3] | part" role="Prüfung der Titel-Länge eines Kapitels">
            <assert role="warn" test="string-length(normalize-space(string-join(title/text(),' '))) &lt; 51 or shorttitle">Langer Titeltext, möglicherweise sollte ein shorttitle-Element verwendet werden</assert>
        </rule>
    </pattern>
    
    <!-- Absatzprüfung -->
    <pattern id="para">
        <rule context="section" role="Absatzprüfung">
            <assert role="warn" test="para">Section enthält keinen Absatz</assert>
        </rule>
    </pattern>
    
    <!-- deprecated-Elemente -->
    <pattern id="deprecated">
        <rule context="metaInfo | target | mdKeywords | personId" role="Target-Elemente">
            <report role="warn" test=".">Das Element <name/> sollte nicht mehr verwendet werden.</report>
        </rule>
    </pattern>
    
    <!-- Listen -->
    <pattern id="listing">
        <rule context="listing//figure | listing//table | listing//box" role="Prüfung der Listenelemente">
            <report role="warn" test="."><name/> sollte nicht in Listen verwendet werden.</report>
        </rule>
        <rule context="listing" role="Prüfung der maximalen Ebenen">
            <report role="warn" test="litem/listing/litem/listing/litem/listing">Diese Liste besitzt mehr als drei Ebenen</report>
        </rule>
    </pattern>
</schema>