<!-- 
  Basis-Elemente der KIS-DTD des  Thieme Verlages
  Copyright (c) 2007-2013 Georg Thieme Verlag KG, Stuttgart
  Version 2.3 vom 18.03.2013

-->

<!-- Block-Elemente -->
<!ENTITY % block "para | embed-para | figure | embed-figure | table | embed-table | formula | header1 | header2 | header3 | listing">

<!-- Inline-Elemente -->
<!ENTITY % inline "#PCDATA | emph | sup | sub | br | target | indexentry | notInFont | footnote | link | uri">
<!ENTITY % inline.small "#PCDATA | emph | sup | sub | notInFont">

<!-- Block-Elemente -->
<!--doc: Kennzeichnet den Namen des Autors -->
<!ELEMENT author (#PCDATA | notInFont | footnote)* >
<!ATTLIST author
    type  CDATA #IMPLIED
>
<!--doc: Vorspanntext -->
<!ELEMENT trailer (%inline;)* >

<!--doc: Überschrift -->
<!ELEMENT title (%inline;)* >
<!ATTLIST title
    type  CDATA #IMPLIED

    %id.attrib;
>
<!--doc: Kurzüberschrift -->
<!ELEMENT shorttitle (#PCDATA)* >
<!ATTLIST shorttitle
    type  CDATA #IMPLIED
>
<!--doc: Unterüberschrift/Zwischenüberschrift -->
<!ELEMENT subtitle (%inline;)* >
<!ATTLIST subtitle
    type  CDATA #IMPLIED
    %id.attrib;
>
<!--doc: Überschrift erster Ebene in Sonderumgebungen -->
<!ELEMENT header1 (%inline;)* >
<!ATTLIST header1
   %id.attrib;
>
<!--doc: Überschrift zweiter Ebene in Sonderumgebungen -->
<!ELEMENT header2 (%inline;)* >
<!ATTLIST header2
    %id.attrib;
>
<!--doc: Überschrift dritter Ebene in Sonderumgebungen -->
<!ELEMENT header3 (%inline;)* >
<!ATTLIST header3
    %id.attrib;
>
<!--doc: Spitzmarke erster Ebene -->
<!ELEMENT paratitle1 (%inline;)* >
<!ATTLIST paratitle1
    %id.attrib;
    
>
<!--doc: Spitzmarke zweiter Ebene -->
<!ELEMENT paratitle2 (%inline;)* >
<!ATTLIST paratitle2
    %id.attrib;
>
<!-- CLS spezifisches Element embed-para -->
<!ELEMENT embed-para (para)*>
<!ATTLIST embed-para %id.attrib;>

<!--doc: Absatz -->
<!ELEMENT para (%inline; | %math.qname;)* >
<!ATTLIST para
    type  (petit)  #IMPLIED
    %id.attrib;
>
<!--doc: Zitat -->
<!ELEMENT quote (para+, origin?) >
<!ATTLIST quote
    type  CDATA  #IMPLIED
    %id.attrib;
>
<!-- doc: Ursprung des Zitats -->
<!ELEMENT origin (%inline.small;)* >

<!-- Abbildungen -->
<!-- CLS spezifisches Element embed-figure -->
<!ELEMENT embed-figure (figure)*>
<!ATTLIST embed-figure %id.attrib;>

<!--doc: Legenden sind optional, sie muessen bei der Generierung aus Word aber immer vorhanden sein -->
<!ELEMENT figure (title?, ((legend?, subfigure+, tableau?) | anaSection+ ))>
<!ATTLIST figure
   type          CDATA  #IMPLIED
   pageno        CDATA #IMPLIED
   counter       (yes | no) #IMPLIED
   number        CDATA  #IMPLIED   
   language ( en-GB | en-US | en-AU | en-CA | fr-FR | fr-CA | es-ES | it-IT | de-DE | de-CH | de-AT ) #IMPLIED  
   materialno    CDATA  #IMPLIED    
   source        CDATA  #IMPLIED   
   sourcechapter    CDATA  #IMPLIED    
   rights        CDATA  #IMPLIED
   %id.attrib;  
>
<!--doc: Container für Multimediaobjekte -->
<!ELEMENT subfigure (mdKeywords?, keywords?, (graphic | audio | video), legend?) >
<!ATTLIST subfigure
   rights  CDATA  #IMPLIED
   type    CDATA  #IMPLIED
   pageno CDATA  #IMPLIED  
   oldnumber CDATA #IMPLIED
   %id.attrib;
>
<!--doc: Element für Bildserien -->
<!ELEMENT anaSection (keywords?, graphic+, legend?) >
<!ATTLIST anaSection   
   pageno CDATA  #IMPLIED         
>
<!--doc: Element für Tableaus -->
<!ELEMENT tableau (graphic) >

<!--doc: Attribut size fuer vorgegebene Grafikgroessen (xs, s, m, l, xl)-->    
<!ELEMENT graphic EMPTY >
<!ATTLIST graphic
   fileref   CDATA  #REQUIRED
   rights  CDATA  #IMPLIED
   source  CDATA  #IMPLIED   
   position  (left | center | right) #IMPLIED
   size      (xs | s | m | l | xl) #IMPLIED 
   sizex     CDATA #IMPLIED 
   sizey     CDATA #IMPLIED 
   type ( image | graphic | scout | orientation | colorLegend ) #IMPLIED
   %id.attrib;
>
<!--doc: Einbindung eines Videos -->
<!ELEMENT video EMPTY >
<!ATTLIST video
   fileref CDATA #REQUIRED
   %id.attrib;
>
<!--doc: Einbindung von Audiodateien/-material -->
<!ELEMENT audio EMPTY >
<!ATTLIST audio
   fileref CDATA #REQUIRED
   %id.attrib;
>
<!--doc: Abbildungslegende -->
<!ELEMENT legend (para | simplelist)+  >

<!--doc: Listen -->
<!ELEMENT listing (litem)+ >
<!ATTLIST listing 
    type (alpha | dash | num) "dash"
    startnum  CDATA #IMPLIED
>
<!ELEMENT litem (para | embed-para | box | figure | embed-figure | table | listing)* >
<!ATTLIST litem
   type   (special) #IMPLIED
>
<!--doc: Einfache Listen -->
<!ELEMENT simplelist (simplelitem)+ >
<!ATTLIST simplelist 
    type (alpha | dash | num ) "dash"
    startnum  CDATA #IMPLIED
>
<!ELEMENT simplelitem (para | embed-para)+ >
<!ATTLIST simplelitem
   type   (special) #IMPLIED
>
<!-- doc: Abkürzungsverzeichnis -->
<!ELEMENT definitionlist (definitionitem+) >
<!ATTLIST definitionlist 
   type (abbreviation | glossary) #IMPLIED
   %id.attrib;
>
<!ELEMENT definitionitem (abbrev?, term+, definition?) >
<!ATTLIST definitionitem
   %id.attrib;
>
<!-- doc: Abkürzung -->
<!ELEMENT abbrev (%inline;)*>
<!ATTLIST abbrev 
    language ( en-GB | en-US | en-AU | en-CA | fr-FR | fr-CA | es-ES | it-IT | de-DE | de-CH | de-AT | hu) #IMPLIED
    %id.attrib;
>
<!-- doc: Begriff -->
<!ELEMENT term (%inline;)*>
<!ATTLIST term 
    language ( en-GB | en-US | en-AU | en-CA | fr-FR | fr-CA | es-ES | it-IT | de-DE | de-CH | de-AT | hu) #IMPLIED
    %id.attrib;
>
<!-- doc: Definition -->
<!ELEMENT definition (%inline;)*>
<!ATTLIST definition
    %id.attrib;
>
<!--doc: Sonderumgebungen -->
<!ELEMENT box (title?, (%block;)+)>
<!ATTLIST box
    type   (H1|H2|H3|H4|H5|H6|H7|remember|caution|definition|summary|profile|exam|addition|practical|therapy|symptome|casestudy|technique|guideline|pitfall|other)  #REQUIRED
    size (l) #IMPLIED
    %id.attrib;
>
<!--doc: Marginalien -->
<!ELEMENT marg (subtitle | paratitle1 | para | listing)* >
<!ATTLIST marg
    %id.attrib;
>
<!--doc: Formeln mit der Option MathML Quellcode einzubinden -->
<!ELEMENT formula (%inline; | %math.qname; | graphic )* >
<!ATTLIST formula
    counter (yes | no) #IMPLIED
    %id.attrib;  
>
<!-- CLS spezifisches Element embed-table -->
<!ELEMENT embed-table (table)*>
<!ATTLIST embed-table %id.attrib;>

<!--doc: Partielles XHTML Tabellenmodell -->
<!ELEMENT table    (caption?, (colgroup? | col*), thead?, tbody, tfoot?) >
<!ATTLIST table    
    align        (left|center|right)         #IMPLIED
    border       CDATA                       #IMPLIED
    bgcolor      CDATA                       #IMPLIED
    cellpadding  CDATA                       #IMPLIED
    cellspacing  CDATA                       #IMPLIED
    frame        (void|above|below|hsides|lhs|rhs|vsides|box|border) #IMPLIED
    rules        (none|groups|rows|cols|all) #IMPLIED
    width        CDATA                      #IMPLIED
    size         (s | m | l | xl )           #IMPLIED    
    type         CDATA  #IMPLIED
    counter       (yes | no) #IMPLIED
    %id.attrib;
>
<!--doc: Tabellenüberschrift -->
<!ELEMENT caption    (%inline;)* >
<!ATTLIST caption    align  (top|bottom|left|right)        #IMPLIED
>
<!--doc: Klammert alle Tabellenspalten -->
<!ELEMENT colgroup (col)+ >
<!ATTLIST colgroup
    align   (left|center|right|justify|char) #IMPLIED
    valign  (top|middle|bottom|baseline)     #IMPLIED
    width   CDATA                            #IMPLIED
>
<!--doc: Definiert eine Tabellenspalte -->
<!ELEMENT col    EMPTY >
<!ATTLIST col
    align   (left|center|right|justify|char) #IMPLIED
    valign  (top|middle|bottom|baseline)     #IMPLIED
    width   CDATA                            #REQUIRED
>
<!--doc: Tabellenkopf -->
<!ELEMENT thead  (tr)+ >
<!ATTLIST thead  
    align    (left|center|right|justify|char) #IMPLIED
    valign   (top|middle|bottom|baseline)     #IMPLIED
>
<!--doc: Tabellenkörper -->
<!ELEMENT tbody  (tr)+ >
<!ATTLIST tbody  
    align    (left|center|right|justify|char) #IMPLIED
    valign   (top|middle|bottom|baseline)     #IMPLIED
>
<!--doc: Tabellenfuß -->
<!ELEMENT tfoot  (tr)+ >
<!ATTLIST tfoot  
    align    (left|center|right|justify|char) #IMPLIED
    valign   (top|middle|bottom|baseline)     #IMPLIED
>
<!--doc: Tabellenzeile -->
<!ELEMENT tr     (td | th)+ >
<!ATTLIST tr     
    align    (left|center|right|justify|char) #IMPLIED
    bgcolor  CDATA                            #IMPLIED
    valign   (top|middle|bottom|baseline)     #IMPLIED
>
<!--doc: Tabellenzelle -->
<!ELEMENT td     (para | listing | subtitle | formula | figure | embed-figure)* >
<!ATTLIST td     
    align    (left|center|right|justify|char) #IMPLIED
    bgcolor  CDATA                            #IMPLIED
    colspan  NMTOKEN                          #IMPLIED
    rowspan  NMTOKEN                          #IMPLIED
    valign   (top|middle|bottom|baseline)     #IMPLIED
    width    CDATA                            #IMPLIED
>
<!--doc: Vorspalte einer Tabelle (vertikaler Tabellenkopf) -->
<!ELEMENT th     (para | figure | embed-figure)* >
<!ATTLIST th     
    align    (left|center|right|justify|char) #IMPLIED
    bgcolor  CDATA                            #IMPLIED
    colspan  NMTOKEN                          #IMPLIED
    rowspan  NMTOKEN                          #IMPLIED
    valign   (top|middle|bottom|baseline)     #IMPLIED
    width    CDATA                            #IMPLIED
>
<!--doc: literature muss im Template mit einer automatischen Nummerierung versehen werden,
    damit eine dynamische Nummernvergabe moeglich ist. Die Nummern in den Verweisen können
    durch link/target dargestellt werden  -->
<!ELEMENT literature (%inline;)* >
<!ATTLIST literature
          %id.attrib; 
>

<!-- Inline Elemente -->
<!--doc: Hervorhebung -->
<!ELEMENT emph (%inline;)* >
<!ATTLIST emph
    type (bold | italic | space | under | special | marker) #REQUIRED
>
<!--doc: Tiefstellung -->
<!ELEMENT sub (#PCDATA | emph | sub | sup | notInFont)* >

<!--doc: Hochstellung -->
<!ELEMENT sup (#PCDATA | emph | sub | sup | notInFont)* >

<!--doc: Softreturn -->
<!ELEMENT br EMPTY >

<!--doc: Markierung für Zeichen, die nicht in den Thieme-Fonts enthalten sind -->
<!ELEMENT notInFont (#PCDATA)* >
<!ATTLIST notInFont
    fname CDATA  #IMPLIED
>
<!--doc: Fussnote -->
<!ELEMENT footnote (para+) >
<!ATTLIST footnote
    id ID  #REQUIRED
    type CDATA  #IMPLIED
>
<!-- doc: interne Links -->
<!ELEMENT link (%inline.small;)* >
<!ATTLIST link
   target (page | part | section | table | figure | audio | video | formula | excursus | literature) #IMPLIED
   %idref.attrib;
>
<!--doc: Links auf Webseiten -->
<!ELEMENT uri (#PCDATA | notInFont)* >
<!ATTLIST uri
   href  CDATA   #REQUIRED
   type (url | email) #IMPLIED
>
<!--doc: Zielmarke eines Links -->
<!ELEMENT target EMPTY>
<!ATTLIST target
  %id.attrib;
>
<!--doc: Indexeintrag für sechs Ebenen -->
<!ELEMENT indexentry (entry1, (entry2, (entry3, (entry4, (entry5, (entry6)?)?)?)?)?, concept*) >
<!ATTLIST indexentry
    emph  (bold | italic | bolditalic)  #IMPLIED
    ref     CDATA  #IMPLIED
    index   CDATA  #IMPLIED
    %id.attrib;
>
<!ELEMENT entry1 (#PCDATA | sub | sup)* >
<!ELEMENT entry2 (#PCDATA | sub | sup)* >
<!ELEMENT entry3 (#PCDATA | sub | sup)* >
<!ELEMENT entry4 (#PCDATA | sub | sup)* >
<!ELEMENT entry5 (#PCDATA | sub | sup)* >
<!ELEMENT entry6 (#PCDATA | sub | sup)* >

<!ELEMENT concept EMPTY>
<!ATTLIST concept
    type (TT | ASYL | icd10 | mesh | ops) #REQUIRED
    cidref CDATA #REQUIRED
    level (1|2|3|4|5|6|7|8|9) #IMPLIED
>