<!-- 
   Modul für die Erfassung von Metainformationen
   Copyright (c) 2014 Georg Thieme Verlag KG, Stuttgart
   06.11.2014
 -->

<!ELEMENT meta ( categories | collaborator | contributors |docalttitle | docdate | doctitle |  docsubtitle | doi | fignumber | isbn | issn | keywords | language | materialid |
				metadata | moduleid | note | publisher | relatedobjects | series | subseries | source | version | volume | xi:include)* >
<!ATTLIST meta 
		xml:base CDATA #IMPLIED >

<!ELEMENT metadata (#PCDATA)*>
<!ATTLIST metadata
   type    (numbering | searchlevel | searchterm | author | gk | gk_uk | gk_uk_d | examen_datum | examen_tag | frage_nr | frage_art | link | key_aktuell | 
           examen_fach | key_symptom | key_gkalt | key_gkneu | key_organ | key_erkrankung | key_sonstiges | 
           frage_typ | fach_mb | krankheiten_mb | symptome_mb | organe_mb | untersuchungen_mb ) #IMPLIED

   medilearn ( schwierigkeitsklasse | schwierigkeit | trennschaerfe | gekreuzt_a | gekreuzt_b | gekreuzt_c | gekreuzt_d | gekreuzt_e) #IMPLIED

   project (radbase | enes | exon | surgerybase | vetcenter) #IMPLIED 

>
<!--doc: DOI (Digital Object Identifier); im Modul litref deklariert -->
<!ELEMENT doi (#PCDATA)>
<!--doc: Materialnummer des Werkes aus SAP -->
<!ELEMENT materialid (#PCDATA)>
<!-- doc:  -->
<!ELEMENT moduleid (#PCDATA)>

<!ELEMENT language (#PCDATA)>

<!--doc: Kategorisierung des Buches -->
<!ELEMENT categories (category+) >
<!ELEMENT category (#PCDATA)>
<!ATTLIST category
medicalbranch (ains | anatomy | dentistry | dermatology | gynecologyandobstetrics | internalmedicine | logopedics | neurology | ophthalmology | orthopedicsandtraumasurgery | otolaryngology | pediatrics | psychiatryandpsychotherapy | 
radiology | surgery | urology | varia) #IMPLIED>

<!--doc: Schlagwörter -->
<!ELEMENT keywords (keyword+)>
<!ELEMENT keyword (#PCDATA)>
<!ATTLIST keyword 
		  %lang.attrib;
>

<!-- doc: ISBN des Produkts; im Modul litref deklariert-->
<!--<!ELEMENT isbn    (#PCDATA)>
<!ATTLIST isbn
		  type    (print | epub | ePub | epdf | ePDF | online | restofworld) #IMPLIED
>-->

<!--doc: Erstellungs-, Änderungs- und Erscheinungsdatum  -->
<!ELEMENT docdate (#PCDATA)>
<!ATTLIST docdate
		  type (created | modified | released ) #REQUIRED
>
<!--doc: Auflage bzw. Onlineversion des Werkes-->
<!ELEMENT version (#PCDATA)>
<!ATTLIST version
          type (online | print) #REQUIRED
>

<!--doc: Reihentitel -->
<!--<!ELEMENT series (#PCDATA)>-->
<!--doc: untergeordneter Reihentitel -->

<!ELEMENT subseries (#PCDATA)>

<!--doc: ISSN für Serien; im Modul litref deklariert-->
<!--<!ELEMENT issn (#PCDATA)>-->

<!--doc: Band deklariert in litref -->
<!--<!ELEMENT volume (#PCDATA)>-->
<!-- doc: Titel des Buches -->

<!ELEMENT doctitle (#PCDATA)>
<!--doc: Untertitel des Buches -->
<!ELEMENT docsubtitle (#PCDATA)>
<!--doc: alternativer Titel, z.B. für elektronische Medien -->
<!ELEMENT docalttitle (#PCDATA)>

<!--doc: Quelle des Ursprungswerkes -->
<!ELEMENT source (sourcedoctitle, copyright)>
<!--doc: Titel des Ursprungswerkes -->
<!ELEMENT sourcedoctitle (#PCDATA)>

<!--doc: -Anzahl der Abbildungen -->
<!ELEMENT fignumber (#PCDATA)>

<!--doc: Verlagsinformationen -->
<!ELEMENT publisher (publishername, copyright, address?, uri*)>
<!ELEMENT publishername (#PCDATA)>
<!ELEMENT copyright (#PCDATA)>

<!--doc: Adressinformationen -->
<!ELEMENT address (street, additional?, zip, city, state?, country?)>
<!ELEMENT street (#PCDATA)>
<!ELEMENT additional (#PCDATA)>
<!ELEMENT zip (#PCDATA)>
<!ELEMENT city (#PCDATA)>
<!ELEMENT state (#PCDATA)>
<!ELEMENT country (#PCDATA)>

<!-- doc: Betragende können eine Körperschaft und eine Person sein oder eine Kombination -->
<!ELEMENT contributors (corporation?, person+) >

<!-- Körperschaft -->
<!ELEMENT corporation (organisation, address?, uri?) >
<!ATTLIST corporation
		  type ( author | editor ) #REQUIRED >

<!--doc: Personangaben -->
<!ELEMENT person (persontitle?, initials?, firstname?, lastname, suffix?, personid*, role*, organisation?, address?, uri?, personpicture?, vita?)>
<!ATTLIST person
		  type ( author | editor | serieseditor ) #REQUIRED
		  priority CDATA #IMPLIED
>

<!ELEMENT persontitle (#PCDATA)>
<!ELEMENT initials (#PCDATA)>
<!--  doc: Im Modul litref deklariert-->
<!--<!ELEMENT firstname (#PCDATA)>
<!ELEMENT lastname (#PCDATA)>-->
<!ELEMENT personids (personid+) >
<!ELEMENT personid (#PCDATA)>
<!ATTLIST personid
	type (gpn | orcid | isni | viaf) #IMPLIED >
<!ELEMENT role (#PCDATA)>
<!ELEMENT organisation (organame, additional*)>
<!ELEMENT organame (#PCDATA)>
<!ELEMENT personpicture (graphic)>
<!ELEMENT vita (para+, listing?)>

<!--doc: Textschnipsel -->
<!ELEMENT note (para+)>
<!ATTLIST note
		  type (abstract | addmaterial | cip | cooperation | copyright | disclaimer | ereader | feedback | formeredition | important | paper | parties | printedin | service | termsofuse | trademark) #REQUIRED
		  xml:base CDATA #IMPLIED >

<!ELEMENT collaborator  (#PCDATA)>
<!ATTLIST collaborator
          type ( consultant | copyediting | design | graphic | origination | photography | printing | programming | stylesheet | translation | typesetting) #REQUIRED>

<!--- related Objects section
 The related objects can be any kind of digital objects which have a relation 
 to the described object. The relation is expressed with e:CLS links.
 For each related object one related_link_object must be created.
 A technical relation is, e.g. a related pdf document to a xml document
 expressed with elements for each possible target.
-->
<!ELEMENT relatedobjects (relpdfio*, relfigureio*)>

<!--- reference to a Figure Information Object in e:CLS -->
<!ELEMENT relfigureio (#PCDATA) >
<!ATTLIST relfigureio
   fileref CDATA  #IMPLIED 
   %id.attrib;
>

<!--- reference to a PDF Information Object in e:CLS -->
<!ELEMENT relpdfio (#PCDATA) >
<!ATTLIST relpdfio
   fileref CDATA  #IMPLIED 
   %id.attrib;
>
