<!-- 
   Modul für die Erfassung von Metainformationen
   Copyright (c) 2007-2012 Georg Thieme Verlag KG, Stuttgart
   Version 2.2 vom 13.07.2012
 -->

<!--ENTITY % id.attrib " cmid ID #IMPLIED 
                       targetid CDATA  #IMPLIED
					   targetversion CDATA  #IMPLIED
					   linkcategory  CDATA  #IMPLIED "-->

<!ELEMENT metaInfo (
mdComment*,
mdLanguage?,
custom*,
mdDoi?,
materialID?,
rightsID?,
moduleID*,
isbn*, 
issn*,
mdJournal?,
mdStartPage?,
mdEndPage?,
mdVolume?,
mdSeries?,
mdSubSeries?,
mdTitle?,
mdSubTitle?,
mdAltTitle?,
mdSourceBookTitle?,
mdSourceChapter?,
fignumber?,
mdCategory*,
mdKeywords?,
mdAbstract?,
publisherInfo?,
publicationDate?,
publicationYear?,
creationDate?,    
dateSubmitted?,
dateAccepted?,
dateModified?,
dateReleased?,
mdEdition?,
mdVersion*,
copyrightNote?,
editorInfo?,
authorInfo?, 
contribInfo?, 
consultantInfo?,
mdOrganisation?,
bibliographicCitation?,
relatedObjects?
) >

<!--doc: Element für Kommentare -->
<!ELEMENT mdComment (#PCDATA)>
<!--doc: Sprache des Dokumentes -->
<!ELEMENT mdLanguage (#PCDATA)>
<!---doc: Angabe der Art der Nummerierung ODER die Anzeige der Trefferebene (bei der Suche) -->
<!ELEMENT custom EMPTY >
<!ATTLIST custom
   type    (numbering | searchlevel | searchterm) #REQUIRED
   project (RadBase | eNes | Walle | Exon | DuR | VetCenter | surgerybase) #IMPLIED 
   value   CDATA  #REQUIRED 
>
<!--doc: DOI (Digital Object Identifier) -->
<!ELEMENT mdDoi (#PCDATA)>
<!--doc: Materialnummer des Werkes aus SAP -->
<!ELEMENT materialID (#PCDATA)>
<!--doc: Rechte-ID -->
<!ELEMENT rightsID (#PCDATA)>
<!-- ??? -->
<!ELEMENT moduleID (#PCDATA)>
<!-- ISSN und ISBN sind in Litref deklariert -->
<!--<!ELEMENT isbn (#PCDATA)>-->
<!--ELEMENT issn (#PCDATA)-->

<!--doc: Name der Zeitschrift -->          
<!ELEMENT mdJournal (#PCDATA)>
<!--doc: Startseite (bei gesplitteten Büchern) -->
<!ELEMENT mdStartPage (#PCDATA)>
<!--doc: Endseite (bei gesplitteten Büchern) -->
<!ELEMENT mdEndPage (#PCDATA)>

<!--doc: Band -->
<!ELEMENT mdVolume (#PCDATA)>
<!--doc: Reihentitel -->
<!ELEMENT mdSeries (#PCDATA)>
<!--doc: untergeordneter Reihentitel -->
<!ELEMENT mdSubSeries (#PCDATA)>
<!--doc: Buchtitel -->
<!ELEMENT mdTitle (#PCDATA)>
<!--doc: Untertitel des Buches -->
<!ELEMENT mdSubTitle (#PCDATA)>
<!--doc: alternativer Titel, z.B. für elektronische Medien -->
<!ELEMENT mdAltTitle (#PCDATA)>
<!--doc: Titel des Ursprungswerkes -->
<!ELEMENT mdSourceBookTitle (#PCDATA)>
<!--doc: Kapitel des Ursprungswerkes -->
<!ELEMENT mdSourceChapter (#PCDATA)>


<!--doc: Kategorisierung des Buches-->
<!ELEMENT mdCategory (#PCDATA)>
<!--doc: Schlagwörter -->
<!ELEMENT mdKeywords ( mdKeyword)*>
<!ELEMENT mdKeyword (#PCDATA)>
<!--doc: Produktbeschreibung zum Buch, Marketingtext -->
<!ELEMENT mdAbstract (#PCDATA)>

<!--doc: Verlagsinformationen -->
<!ELEMENT publisherInfo ( publisherName , publisherDisplayName?, mdAddress?, uri*, logo? )>
<!ELEMENT publisherName (#PCDATA)>
<!ELEMENT publisherDisplayName (#PCDATA)>

<!--doc: Adressinformationen -->
<!ELEMENT mdAddress ( mdAddressAddition?, mdStreet, mdZip, mdCity, mdCountry? ) >
<!ELEMENT mdZip (#PCDATA)>
<!ELEMENT mdCity (#PCDATA)>
<!ELEMENT mdCountry (#PCDATA)>
<!ELEMENT mdStreet (#PCDATA)>
<!ELEMENT mdAddressAddition (#PCDATA)>

<!--doc: Verlagslogo-->
<!ELEMENT logo (graphic)>

<!--doc: Erscheinungsdatum aus VIS -->
<!ELEMENT publicationDate (#PCDATA)>
<!--doc: Jahr der Veröffentlichung aus dem Impressum -->
<!ELEMENT publicationYear (#PCDATA)>
<!--doc: Erstellungsdatum -->
<!ELEMENT creationDate (#PCDATA)>
<!--doc: Abgabedatum -->
<!ELEMENT dateSubmitted (#PCDATA)>
<!--doc: Annahmedatum -->
<!ELEMENT dateAccepted (#PCDATA)>
<!--doc: Änderungsdatum -->
<!ELEMENT dateModified (#PCDATA)>
<!--doc: Freigabedatum -->
<!ELEMENT dateReleased (#PCDATA)>

<!--doc: Auflage -->
<!ELEMENT mdEdition (#PCDATA)>
<!--doc: Onlineversion des Werkes-->
<!ELEMENT mdVersion (#PCDATA)>
<!ATTLIST mdVersion
          type CDATA #IMPLIED>
<!--doc: Copyright-Vermerk -->
<!ELEMENT copyrightNote (#PCDATA)>

<!--doc: Herausgeber -->
<!ELEMENT editorInfo ( mainEditor+ , coEditor* )>
<!--doc: Hauptherausgeber -->
<!ELEMENT mainEditor ( mdPerson )>
<!--doc: Co-Herausgeber -->
<!ELEMENT coEditor   ( mdPerson )>

<!--doc: Autor -->
<!ELEMENT authorInfo ( mainAuthor+ , coAuthor*)>
<!--doc: Hauptautor -->
<!ELEMENT mainAuthor ( mdPerson )>
<!--doc: Co-Autor -->
<!ELEMENT coAuthor   ( mdPerson )>

<!-- Infos über weitere Mitarbeiter -->
<!ELEMENT contribInfo ( mainContrib+ , coContrib* )>
<!--doc: Hauptmitarbeiter -->
<!ELEMENT mainContrib ( mdPerson )>
<!--doc: Co-Mitarbeiter -->
<!ELEMENT coContrib   ( mdPerson )>

<!-- Fachbeirat -->
<!ELEMENT consultantInfo ( mainConsultant+ , coConsultant* )>
<!--doc: Hauptbeirat -->
<!ELEMENT mainConsultant ( mdPerson )>
<!--doc: Co-Beirat -->
<!ELEMENT coConsultant   ( mdPerson )>
<!--doc: Personangaben -->
<!ELEMENT  mdPerson          ( ( pName  | ( pTitle*, pFirstName?, pMiddleName?, pLastName ) ) ,
                               personID? , mdAddress? , uri*, 
                               personPicture? , personVita? , personBiography?, mdOrganisation? )
>
<!-- 
  pName contains the complete persone name including title, first, mittle, last name
  This element should only be used if a seperation into the 
  semantic elements is not possible.
-->
<!ELEMENT pName  (#PCDATA)>
<!ELEMENT pTitle (#PCDATA)>
<!ELEMENT pFirstName (#PCDATA)>
<!ELEMENT pMiddleName (#PCDATA)>
<!ELEMENT pLastName (#PCDATA)>
<!ELEMENT personID (#PCDATA)>
<!ELEMENT personVita (#PCDATA)>
<!ELEMENT personBiography (#PCDATA)>
<!ELEMENT personPicture ( graphic )>

<!-- Organisation -->
<!ELEMENT mdOrganisation ( mdOrgaName, mdAddition*, mdAddress?, uri* )>
<!ELEMENT mdOrgaName (#PCDATA)>
<!ELEMENT mdAddition (#PCDATA)>

<!--doc: Art der Zitierung eines Werkes -->
<!ELEMENT bibliographicCitation (#PCDATA)>

<!--- related Objects section
 The related objects can be any kind of digital objects which have a relation 
 to the described object. The relation is expressed with e:CLS links.
 For each related object one related_link_object must be created.
 A technical relation is ( f. ex. a related pdf document to a xml document)
 expressed with elements for each possible target.
-->
<!ELEMENT relatedObjects ( relPdfIo*, relFigureIo*, relVideoIo*, relAudioIo*, relGraphicIo*, relWordIo* )>

<!--- reference to a Figure Information Object in e:CLS -->
<!ELEMENT relFigureIo (#PCDATA) >
<!ATTLIST relFigureIo
   fileref CDATA  #IMPLIED 
   %id.attrib;
>
<!--- reference to a MS Word Information Object in e:CLS -->
<!ELEMENT relWordIo (#PCDATA) >
<!ATTLIST relWordIo
   fileref CDATA  #IMPLIED 
   %id.attrib;
>

<!--- reference to a PDF Information Object in e:CLS -->
<!ELEMENT relPdfIo (#PCDATA) >
<!ATTLIST relPdfIo
   fileref CDATA  #IMPLIED 
   %id.attrib;
>

<!--- reference to a Graphic Information Object in e:CLS -->
<!ELEMENT relGraphicIo (#PCDATA) >
<!ATTLIST relGraphicIo
   fileref CDATA  #IMPLIED 
   %id.attrib;
>

<!--- reference to a Audio Information Object in e:CLS -->
<!ELEMENT relAudioIo (#PCDATA) >
<!ATTLIST relAudioIo
   fileref CDATA  #IMPLIED 
   %id.attrib;
>

<!--- reference to a Video Information Object in e:CLS -->
<!ELEMENT relVideoIo (#PCDATA) >
<!ATTLIST relVideoIo
   fileref CDATA  #IMPLIED 
   %id.attrib;
>
