<?xml version="1.0" encoding="UTF-8"?>
<!-- 
  Schematron als Ergänzung zur KIS DTD 2.2
  Patrick Schwarz, (c) 2013 Georg Thieme Verlag KG Stuttgart
  Features: 
    Linkcheck, Abbildungsprüfung, Section ohne Titel
  Changelog:
    v0.1 initial release, ps, 15.03.2012
    v1.0, aufgeräumt, Prüfung im Images- und Rootordner, Check für alte Boxtypen und leere Elemente
    v1.1, 24.08.12 Dateipfad für Abbildungsprüfugn umgestellt, da nicht mehr funktionsfähig
    v1.2, 29.11.12 Links ohne id aufzählen; Prüfung Datumsangaben, ISBN-Nummer, Materialnummer; URL-Filter gegen Schematron-Abbruch bei Sonderzeichen (Abb.)
    v1.3, 14.12.12 Neues Metadatenmodell ergänzt
    v1.4, 07.01.13 Warnungen und Fehler korrigiert
    v1.5, 04.02.13 Formulierung, empty Element Prüfung korrigiert
    v1.6, 25.02.13 Prüfregeln für Tabellen, externe Links, x-Level, leere Dateinamen in Abbildungen, Section-Titellänge
    v1.7, 20.03.13 Prüfung nach mehrfach gesetzten meta-Elementen, Prüfung nach unnötigen emphs
    v1.8, 11.04.13 Bugfix Section-Titellänge und uri-Prüfung, Deprecated-Elemente
-->
<schema xmlns="http://purl.oclc.org/dsdl/schematron" see="http://wiki.medionet.de/Thieme/4._Oxygen/Schematron" queryBinding="xslt2" xml:lang="de-DE">
    <let name="version" value="'kiSCHeck-22, v1.8-11.04.13'"/>
    <let name="dir_fileref" value="'images/'"/>
    <ns uri="java:java.io.File" prefix="f"/>
    <ns uri="java:java.net.URI" prefix="u"/>
    <title>KIS DTD 2.2 Schematron</title>

    <!-- Infomeldungen -->
    <pattern id="info">
        <rule context="/" role="Version info and statistics">
            <report test="." role="info">
                <value-of select="concat('=== ',current-dateTime(),': Processing ',base-uri(),' with ', $version,' ===')"/>
            </report>
            <report test="." role="info">
                <value-of select="concat('[Statistics] Outgoing links: ',count(//link[@idref = //@id]),' valid + ',count(//link/@idref) - count(//link[@idref = //@id]),' invalid + ',count(//link[not(@idref)]),' empty = ',count(//link),' total')"/>
            </report>
            <report test="." role="info">
                <value-of select="concat('[Statistics] Targets for incoming links: ',count(//@id[. = //link/@idref]),' used + ',count(//@id) - count(//@id[. = //link/@idref]),' unused = ',count(//@id),' total')"/>
            </report>
            <report test="." role="info">
               
                <value-of select="concat('[Statistics] Figures: ',count(//@fileref[not(f:exists(f:new(resolve-uri(concat($dir_fileref,replace(., '[^a-zA-Z0-9_\-. ]','')), base-uri())))) and not(f:exists(f:new(resolve-uri(replace(., '[^a-zA-Z0-9_\-. ]',''), base-uri()))))]),' of ',count(//graphic),' missing, of which ',count(//graphic[@fileref='']),' are empty')"/>
            </report>
        </rule>
    </pattern>
    
    <!-- Metadaten prüfen -->
    <!--pattern id="metadata">
        <rule context="meta/*" role="Gültigkeit der Metadaten prüfen">
            <let name="name" value="name()"/>
            <let name="type" value="@type"/>
            <report test=".[count(parent::*/*[name()=$name and @type=$type])>1]">Das Element <name/> mit dem Attributwert <value-of select="@type"/> ist mehrfach gesetzt.</report>
            <report test=".[count(parent::*/*[name()=$name and not(@type)])>1]">Das Element <name/> ist mehrfach gesetzt.</report>
        </rule>
    </pattern-->
    
    <!-- Nummern prüfen -->
    <!--pattern id="numbers">
        <rule context="materialID | materialid" role="Gültigkeit der Materialnummer prüfen">
            <report test=". = '1234560101'" role="warn">Die Materialnummer ist ungültig</report>
            <assert test="matches(., '^[0-9]{6,10}$') or string-length(.) = 0">Die Materialnummer muss aus einer 6-10 stelligen Zahl bestehen</assert>
        </rule>
        <rule context="isbn" role="Gültigkeit der ISBN-Nummer prüfen">
            <let name="checksum" value="number(substring(., string-length(), 1))"/>
            <let name="digits" value="for $i in reverse(string-to-codepoints(substring(., 1, string-length() -1))) return $i - 48"/>
            <let name="calculation" value="sum((for $i in $digits[(position()) mod 2 = 1] return $i * 3, for $i in $digits[(position()) mod 2 = 0] return $i)) mod 10"/>
            <report test="string-length(.) ne 13 or (if ($calculation ne 0) then (10 - $calculation) else 0) ne $checksum" role="warn">Die ISBN-Nummer ist ungültig</report>
            <let name="value" value="."/>
            <report test="count(//isbn[text()=$value]) > 1" role="warn">Es sind mehrere ISBN mit gleicher Nummer definiert</report>
        </rule>
        <rule context="publicationDate | creationDate | dateSubmitted | dateAccepted | dateModified | dateReleased | docdate" role="Gültigkeit des Datums prüfen">
            <assert test="matches(., '^([\d]{4})-(1[0-2]|0[1-9])-(3[0-1]|0[1-9]|[1-2][\d])$')" role="warn">Das Datum ist ungültig</assert>
        </rule>
    </pattern-->

    <!-- Verlinkungen prüfen -->
    <pattern see="http://wiki.medionet.de/Thieme/3._XML_Grundlagen/Verlinkungen" id="links">
        <rule context="link/@idref" role="List outgoing links with missing targets">
            <assert test=". = //node()/@id" role="error">Link <value-of select="."/> does not have a valid target</assert>
        </rule>
        <rule context="link[not(@idref) and not(@cmid)]" role="List outgoing links without id">
            <report test="." role="warn">Link <value-of select="."/> does not have a target definition</report>
        </rule>
        <rule context="target/@id" role="List link targets that are not pointed to">
            <assert test=". = //link/@idref" role="info">Target <value-of select="."/> is not used by incoming links as a target</assert>
        </rule>
        <!--Inserted by Michael Wachinger 2014-04-04 for identifying unused literautre references--> 
        <rule context="otherref/@id" role="List link targets that are not pointed to">
            <assert test=". = //link/@idref" role="info">Reference <value-of select="."/> is not used by incoming links as a target</assert>
       </rule>
        <rule context="bkref/@id" role="List link targets that are not pointed to">
            <assert test=". = //link/@idref" role="info">Reference <value-of select="."/> is not used by incoming links as a target</assert>
        </rule>
        <rule context="jnref/@id" role="List link targets that are not pointed to">
            <assert test=". = //link/@idref" role="info">Reference <value-of select="."/> is not used by incoming links as a target</assert>
        </rule>
        <rule context="literature/@id" role="List link targets that are not pointed to">
            <assert test=". = //link/@idref" role="info">Reference <value-of select="."/> is not used by incoming links as a target</assert>
        </rule>
        <rule context="figure/@id" role="List link targets that are not pointed to">
            <assert test=". = //link/@idref" role="info">Figure <value-of select="."/> is not used by incoming links as a target</assert>
        </rule>
        <rule context="table/@id" role="List link targets that are not pointed to">
            <assert test=". = //link/@idref" role="info">Table <value-of select="."/> is not used by incoming links as a target</assert>
        </rule>
              
        <!-- MW insert end -->
        
        <rule context="@href[not(../@type='email')]" role="Check validity of internet links">
            <assert test="matches(.,'^(https?|ftp)://[^\s/$.?#].[^\s]*$')">The given URI is not valid</assert>
        </rule>
      
        <rule context="@href[../@type='email']" role="Check validity of e-mail addresses">
            <assert test="matches(.,'^[^0-9][a-zA-Z0-9_\-]*([.][a-zA-Z0-9_\-]+)*[@][a-zA-Z0-9_\-]+([.][a-zA-Z0-9_\-]+)*[.][a-zA-Z]{2,4}$')">The given e-mail address is not valid</assert>
        </rule>
        <!--rule context="para/text() | emph/text() | footnote/text() | literature/text()" role="Nicht getaggte Links aufspüren">
            <report role="warn" test="contains(.,'www.')">Möglicherweise ist in diesem Absatz eine URL nicht verlinkt.</report>
            <report role="warn" test="contains(.,'@')">Möglicherweise ist in diesem Absatz eine E-Mail nicht verlinkt.</report>
        </rule-->
    </pattern>

    <!-- Abbildungsprüfung -->
    <!--pattern see="http://wiki.medionet.de/Thieme/Oxygen/Abbildungen" id="figures">
        <rule context="@fileref" role="Gültigkeit der Abbildungslinks prüfen">
            <let name="file" value="f:new(resolve-uri(replace(., '[^a-zA-Z0-9_\-. ]',''), base-uri()))"/>
            <let name="file2" value="f:new(resolve-uri(concat($dir_fileref,replace(., '[^a-zA-Z0-9_\-. ]','')), base-uri()))"/>
            <report test="matches(., '[^a-zA-Z0-9_\-. ]')">Die Abbildung <value-of select="."/> enthält Sonderzeichen und kann nicht geprüft werden</report>
            <report test="matches(., '[A-Z ]')" role="warn">Die Abbildung <value-of select="."/> sollte keine Leerzeichen oder Großbuchstaben enthalten</report>
            <assert test="string-length() > 0">Eine Abbildung hat keinen Dateinamen</assert>
            <assert test="f:exists($file) or f:exists($file2)" role="warn"> Abbildung <value-of select="."/> fehlt</assert>
        </rule>
    </pattern-->

    <!-- Tabellenprüfung (ignoriert rowspan-Tabellen) -->
    <!--pattern see="http://wiki.medionet.de/Thieme/3._XML_Grundlagen/Tabellen" id="tables">
        <rule context="table[not(.//@rowspan)]/.//tr" see="http://wiki.medionet.de/Thieme/3._XML_Grundlagen/Tabellen#Spaltenbreiten" role="Colspan-Überprüfung bei Tabellen">
            <assert test="number(count(*[not(@colspan)])+sum(.//@colspan)) = number(count(../..//col))">Die Anzahl der Spalten stimmt nicht mit den col-Werten überein</assert>
        </rule>
    </pattern-->

    <!-- Boxen überprüfen -->
    <!--pattern id="boxes">
        <rule context="box" role="Fehlerhafte Boxen">
            <assert role="info" test="title">Diese Box hat keinen Titel</assert>
            <report role="warn" test="starts-with(@type, 'H')" see="http://wiki.medionet.de/Thieme/2._TReX_Word/Boxen%3a_Eine_%c3%9cbersicht">Sie benutzen veraltete Box-Typen</report>
        </rule>
    </pattern-->
    
    <!-- Leere Elemente -->
    <!--pattern id="emptyelements">
        <rule context="node() [not(name()='br') and not(name()='graphic') and not(name()='audio') and not(name()='video') and not(name()='col') and not(name()='target') and not(name()='concept') and not(name()='custom')]" role="Leere Elemente auffinden">
            <report role="info" test="string-length(normalize-space(.)) = 0 and not(*)">Leeres Element <value-of select="name(.)"/></report>
        </rule>
    </pattern-->
    
    <!-- Auszeichnungen -->
    <pattern id="emphasis">
        <rule context="emph" role="Checking emphases">
            <report role="warn" test=".[following-sibling::node()[1][name()='emph' and @type=preceding-sibling::*[1]/@type]]">Adjacent emph elements could be merged</report>
            <report role="warn" test="string-length(normalize-space())=0">Empty emph element</report>
        </rule>
    </pattern>
    
    <!-- x-level -->
    <!--pattern id="xlevel">
        <rule context="section[@level='x']" role="Prüfung des x-Levels">
            <report test=".//section[@level='x']">Das x-Level darf in einem Hierarchiepfad nur einmal verwendet werden</report>
        </rule>
    </pattern-->
    
    <!-- title-Prüfung -->
    <pattern id="title">
        <rule context="section[count(ancestor-or-self::section) &lt; 3] | part" role="Checking length of chapter title">
            <assert role="warn" test="string-length(normalize-space(string-join(title/text(),' '))) &lt; 51 or shorttitle">Long chapter title, it might make sense to use the shorttilte element for feeding running heads</assert>
        </rule>
    </pattern>
    
    <!-- deprecated-Elemente -->
    <!--pattern id="deprecated">
        <rule context="metaInfo | target | mdKeywords | personId" role="Target-Elemente">
            <report role="warn" test=".">Das Element <name/> sollte nicht mehr verwendet werden.</report>
        </rule>
    </pattern-->
</schema>