<?xml version="1.0" encoding="UTF-8"?>

<!-- TRIAS-Schematron als Ergänzung zur KIS-DTD und zum KIS-Schematron -->
<!-- Konrad Seidel, Georg Thieme Verlag KG, 2017 -->
<!-- VERSION 2.0, 27.01.2017 -->

<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2" xmlns:sqf="http://www.schematron-quickfix.com/validator/process">


    <!-- überprüft, ob es in TRIAS-Dokumenten hierarchisch auch nur bis zur Ü4 geht, Ausnahme Excursus (Ü5 ist nicht definiert) -->
    <pattern id="ü5">
        <rule context="section[not(@type = 'excursus')]/section">
            <report test="count(ancestor::section[not(@type='excursus')]) &gt; 3">[TRIAS] Unerlaubte Ü5 und hierarchisch tiefere Überschriften *oder* unerlaubt innerhalb eines Exkurses eine Zwischenüberschrift zweiter Ebene (erlaubt und im Layout definiert ist nur die ZÜ erster Ebene).</report>
        </rule>
    </pattern>
    
    
    <!-- überprüft, ob es in TRIAS-Dokumenten nur eine ZÜ in den Exkursen gibt) -->
    <pattern>
        <rule context="section[@type = 'excursus']/section/section">
            <report test=".">[TRIAS] Unerlaubt innerhalb eines Exkurses eine Zwischenüberschrift zweiter Ebene (erlaubt und im Layout definiert ist nur die ZÜ erster Ebene).</report>
        </rule>
    </pattern>


    <!-- überprüft, ob das Sprach-Element in <meta> vorhanden, dieses nicht leer und üblicherweise mit 'DE' gefüllt ist (<language>DE</language>) -->
    <pattern id="sprache">
        <rule context="language">
            <assert test="contains(., 'DE')">[TRIAS] Element 'language' sollte nicht leer und üblicherweise mit 'DE' gefüllt sein, da wir deutschsprachige Bücher verlegen.</assert>
        </rule>
        <rule context="meta">
            <assert test="language">[TRIAS] Element 'language" fehlt.</assert>
        </rule>
    </pattern>


    <!-- überprüft, ob innerhalb von vita eine fette Hervorhebung vorhanden ist (üblicherweise wird der Autor so hervorgehoben) -->
    <pattern id="vita_autor">
        <rule context="vita/para">
            <assert test="emph[@type = 'bold']">[TRIAS] Autor/in/Autoren innerhalb von 'vita' bitte fett hervorheben.</assert>
        </rule>
    </pattern>


    <!-- explizite kursive Auszeichnung ist bei TRIAS nicht erlaubt/ungewöhnlich, Warnung -->
    <pattern>
        <rule context="para | literature | header1 | header2 | title | paratitle1 | paratitle2 | caption | ingredient">
            <report role="warning" test="emph[@type='italic']">[TRIAS] Kursiv-Auszeichnung ist bei TRIAS ungewöhnlich, der DNB-Eintrag und Literatur-Titel sollten fett hervorgehoben sein. In begründeten Ausnahmefällen kann kursiv sinnvoll sein.</report>
        </rule>
    </pattern>


    <!-- Ziffern bei Vitamin B müssen tiefgestellt sein -->
    <pattern>
        <rule context="para | literature | header1 | header2 | title | paratitle1 | paratitle2 | caption | ingredient">
            <report test="matches(., 'Vitamin[a-z]*\s{1,3}B\s{1,3}\d')">[TRIAS] Ziffern bei Vitamin B bitte tiefgestellt.</report>
        </rule>
    </pattern>


    <!-- übliche Brüche sind als echte Unicode-Zeichen umzusetzen (nicht 1/2 oder <sup>1</sup>/<sub>2</sub>, Regel 1 -->
    <pattern>
        <rule context="para/text() | literature/text() | header1/text() | header2/text() | title/text() | paratitle1/text() | paratitle2/text() | caption/text() | ingredient/text()">
            <report test="matches(., '\D\d/\d')">[TRIAS] Brüche üblicher Art bitte als echte Zeichen einfügen.</report>
        </rule>
    </pattern>


    <!-- übliche Brüche sind als echte Unicode-Zeichen umzusetzen (nicht 1/2 oder <sup>1</sup>/<sub>2</sub>, Regel 2 (mit Hoch- und Tiefstellungen -->
    <pattern>
        <rule context="para | literature | header1 | header2 | title | paratitle1 | paratitle2 | caption | ingredient">
            <report test="sup[matches(text(),'^\d$')]/following-sibling::text()[. = '/']/following-sibling::sub[matches(text(),'^\d$')]">[TRIAS] Brüche üblicher Art bitte als echte Zeichen einfügen.</report>
        </rule>
    </pattern>


    <!-- Doppelpunkt in Zutat als Indiz für für Zutatengruppen-Titel -->
    <pattern>
        <rule context="ingredient/text()">
            <report role="warning" test="matches(., ':')">[TRIAS] Doppelpunkt in der Zutat könnte ein Hinweis auf einen Titel einer Zutatengruppe sein – bitte prüfen.</report>
        </rule>
    </pattern>

    <!-- Marker-Auszeichnung ungewöhnlich -->
    <pattern>
        <rule context="para | literature | header1 | header2 | title | paratitle1 | paratitle2 | caption | ingredient">
            <report role="warning" test="emph[@type='marker']">[TRIAS] Marker-Auszeichnung ist grundsätzlich nicht definiert. In begründeten Ausnahmefällen kann sie sinnvoll sein - bitte mit ProM kommunizieren.</report>
        </rule>
    </pattern>


    <!-- zwei Links ohne Trennzeichen (Komma) direkt hintereinander ungewöhnlich, Teil 1 -->
    <pattern>
        <rule context="link">
            <report test="matches(preceding-sibling::node()[1][self::text()], '^\s*$') and preceding-sibling::node()[2][name()='link' and @target=current()/@target]">[TRIAS] Zwei Verweise direkt hintereinander ohne Trennzeichen sind nicht sinnvoll.</report>
        </rule>
    </pattern>


    <!-- zwei Links ohne Trennzeichen (Komma) direkt hintereinander ungewöhnlich, Teil 2 -->
    <pattern>
        <rule context="link">
            <report test="preceding-sibling::node()[1][name()='link' and @target=current()/@target]">[TRIAS] Zwei Verweise direkt hintereinander ohne Trennzeichen sind nicht sinnvoll.</report>
        </rule>
    </pattern>


    <!-- Exkurse ohne Trailer nicht zulässig -->
    <pattern>
        <rule context="section[@type = 'excursus']">
            <assert test="trailer">[TRIAS] Exkurse bitte mit Trailer versehen.</assert>
        </rule>
    </pattern>


    <!-- Warnung, wenn Facebook-PI fehlt -->
    <pattern>
        <rule context="meta">
            <assert role="warning" test="descendant::processing-instruction('wsFB')">[TRIAS] PI für Facebook-Logo fehlt in den Meta-Daten.</assert>
        </rule>
    </pattern>


    <!-- Warnung, wenn Pinterest-PI fehlt -->
    <pattern>
        <rule context="meta">
            <assert role="warning" test="descendant::processing-instruction('wsPinterest')">[TRIAS] PI für Pinterest fehlt in den Meta-Daten.</assert>
        </rule>
    </pattern>


    <!-- leeres collaborator-Element ungünstig, besser mit Blockaden füllen, Teil 1-->
    <pattern>
        <rule context="collaborator">
            <assert test="text()">[TRIAS] Element 'collaborator' bitte füllen, ggf. mit Blockaden.</assert>
        </rule>
    </pattern>

    <!-- leeres collaborator-Element ungünstig, besser mit Blockaden füllen, Teil 2-->
    <pattern>
        <rule context="collaborator/text()">
            <report test="matches(., '^\s+$')">[TRIAS] Element 'collaborator' bitte füllen, ggf. mit Blockaden.</report>
        </rule>
    </pattern>


    <!-- Leerzeichen am Beginn/Ende von entry1/ entry2 nicht erlaubt-->
    <pattern>
        <rule context="entry1/text() | entry2/text() | entry3/text()">
            <report test="matches(., '^\s+') or matches(., '\s+$')">[TRIAS] Leerzeichen am Beginn oder Ende von 'entry' sind nicht erlaubt.</report>
        </rule>
    </pattern>


    <!-- nur Seitenverweise erlaubt -->
    <pattern>
        <rule context="link">
            <assert test="@target = 'page'">[TRIAS] Im TRIAS-Kontext sind nur Seitenverweise zulässig.</assert>
        </rule>
    </pattern>


    <!-- kein counter-Attribut in <figure>, Warnung -->
    <!--
        <pattern>
        <rule context="figure">
            <report role="warning" test="@counter">[TRIAS] Im TRIAS-Kontext ist das counter-Attribut überflüssig.</report>
        </rule>
        </pattern>
    -->


    <!-- kein number-Attribut in <figure>, Warnung -->
    <!-- entfernt, da nicht relevant
        <pattern>
        <rule context="figure">
            <report role="warning" test="@number">[TRIAS] Im TRIAS-Kontext ist das number-Attribut überflüssig.</report>
        </rule>
        </pattern>
    -->


    <!-- Fehler bei Word-Verweisfragmenten -->
    <pattern>
        <rule context="para | literature | header1 | header2 | title | paratitle1 | paratitle2 | caption | ingredient">
            <report test="matches(., 'HYPERLINK')">[TRIAS] Verweisfehler, bitte prüfen.</report>
        </rule>
    </pattern>


    <!-- emph in title -->
    <pattern>
        <rule context="title">
            <report role="warning" test="emph">[TRIAS] Auszeichnung in 'title' ungewöhnlich.</report>
        </rule>
    </pattern>


    <!-- Backslash in Indexeinträgen, kommt wohl bei Anführungszeichen vor -->
    <pattern>
        <rule context="entry1 | entry2 | entry3">
            <report test="matches(., '\\')">[TRIAS] Fehler im Index-Eintrag.</report>
        </rule>
    </pattern>
    
    
    
    <!-- MVS, Medizinverlage, Oswald-Hesse -->
    <pattern>
        <rule context="publisher/copyright/text()">
            <report test="matches(., 'MVS')">[TRIAS] MVS/Medizinverlage ist Geschichte :-)</report>
            <report test="matches(., 'Medizinverlag')">[TRIAS] MVS/Medizinverlage ist Geschichte :-)</report>
        </rule>
    </pattern>
    
    <pattern>
        <rule context="publisher/address/street/text()">
            <report test="matches(., 'Oswald')">[TRIAS] Verlagsadresse falsch.</report>
            <report test="matches(., 'Hesse')">[TRIAS] Verlagsadresse falsch.</report>
        </rule>
    </pattern>
</schema>
