<!-- 
   Modul für das Abbilden von Lexikoneinträgen
   Copyright (c) 2007-2015 Georg Thieme Verlag KG, Stuttgart
 -->
 
 <!-- doc: Klammert alle Lexikoneinträge. Lexikoneinträge sind innerhalb eines Buchteils oder eines Kapitels möglich.-->
<!--~~ <dict>
<p lang="de">Klammert alle Lexikoneinträge. Lexikoneinträge sind innerhalb eines Buchteils oder eines Kapitels möglich.</p>
<p lang="en">Brackets all dictionary entries. Dictionary entries occure in book parts or sections.</p>
~~-->
<!ELEMENT dict (subtitle | entry)+ >

<!-- doc: Kennzeichnet einen Lexikoneintrag -->
<!--~~ <entry>
<p lang="de">Kennzeichnet einen Lexikoneintrag.</p>
<p lang="en">Brackets a single dictionary entry.</p>
~~-->
<!ELEMENT entry (lemma, grammar?, partofspeech?, ipa?, numerus?, etym?, onom?, abbrev?, (monosem | polysem+), deriv?) >
<!ATTLIST entry
    id ID #REQUIRED
>

<!-- doc: Dieses Element wird benutzt, wenn es nur eine Bedeutung zum jeweiligen Lexikoneintrag gibt. -->
<!--~~ <monosem>
<p lang="de">Dieses Element wird benutzt, wenn es nur eine Bedeutung zum jeweiligen Lexikoneintrag gibt.</p>
<p lang="en">This element is used when there is only one definition for the dictionary entry.</p>
~~-->
<!ELEMENT monosem (engl?, synonym?, context, (para | listing | table)*, figure*, literature*, author*) >

<!-- doc: Dieses Element wird benutzt, wenn es mehrere Bedeutungen zum jeweiligen Lexikoneintrag gibt. Ein number-Attribut ist zur Durchnummerierung der Bedeutungen erforderlich.-->
<!--~~ <polysem>
<p lang="de">Dieses Element wird benutzt, wenn es mehrere Bedeutungen zum jeweiligen Lexikoneintrag gibt. Ein number-Attribut ist zur Durchnummerierung der Bedeutungen erforderlich.</p>
<p lang="en">This element is used when there are several definitions for the dictionary entry. The attribute number must be specified for the numeration of each definition.</p>

~~ number
<p lang="de">Ein number-Attribut ist zur Durchnummerierung der Bedeutungen erforderlich.</p>
<p lang="en">The attribute number must be specified for the numeration of each definition.</p>

~~-->
<!ELEMENT polysem (engl?, synonym?, context, (para | listing | table)*, figure*, literature*, author*) >
<!ATTLIST polysem
    number CDATA #REQUIRED
>

<!-- doc: Stichwort-->
<!--~~ <lemma>
<p lang="de">Stichwort</p>
<p lang="en">Keyword</p>
~~-->
<!ELEMENT lemma (%inline;)* >

<!-- doc: Grammatisches Geschlecht-->
<!--~~ <grammar>
<p lang="de">Grammatisches Geschlecht</p>
<p lang="en">Grammatical gender of the word</p>
~~-->
<!ELEMENT grammar (%inline;)* >

<!-- doc: Wortart (Substantiv, Verb, Präfix etc.)-->
<!--~~ <partofspeech>
<p lang="de">Wortart (Substantiv, Verb, Präfix etc.)</p>
<p lang="en">Part of speech (noun, verb, prefix etc.)</p>
~~-->
<!ELEMENT partofspeech (%inline;)* >

<!-- doc: Aussprache, IPA Lautschrift (International Phonetic Alphabet) -->
<!--~~ <ipa>
<p lang="de">Aussprache, IPA Lautschrift (International Phonetic Alphabet)</p>
<p lang="en">Pronounciation, IPA phonetic spelling (International Phonetic Alphabet)</p>
~~-->
<!ELEMENT ipa (%inline;)* >

<!-- doc: Numerus (Singular, Plural)-->
<!--~~ <numerus>
<p lang="de">Numerus (Singular, Plural)</p>
<p lang="en">Number (singular, plural)</p>
~~-->
<!ELEMENT numerus (%inline;)* >
<!ATTLIST numerus
    type (singular | plural) #REQUIRED
>

<!-- doc: Etymologie (Herkunft) des Wortes-->
<!--~~ <etym>
<p lang="de">Etymologie (Herkunft) des Wortes</p>
<p lang="en">Etymology (origin) of the word</p>
~~-->
<!ELEMENT etym (%inline;)* >

<!-- doc: Onomastik (Namensforschung)-->
<!--~~ <onom>
<p lang="de">Onomastik (Namensforschung)</p>
<p lang="en">Onomastic (name studies)</p>
~~-->
<!ELEMENT onom (%inline;)* >

<!-- doc: Englischer Begriff (bei deutschem Eintrag)-->
<!--~~ <engl>
<p lang="de">Englischer Begriff (bei deutschem Eintrag)</p>
<p lang="en">English term (in a german entry)</p>
~~-->
<!ELEMENT engl (%inline;)* >

<!-- doc: Synonym -->
<!--~~ <synonym>
<p lang="de">Synonym</p>
<p lang="en">Synonym</p>
~~-->
<!ELEMENT synonym (%inline;)* >

<!-- doc: Zusammenhang, in dem das Wort benutzt wird.-->
<!--~~ <context>
<p lang="de">Zusammenhang, in dem das Wort benutzt wird.</p>
<p lang="en">Context in which the word is being used.</p>
~~-->
<!ELEMENT context (%inline;)* >

<!-- doc: Abgeleitete Wortformen -->
<!--~~ <deriv>
<p lang="de">Abgeleitete Wortformen</p>
<p lang="en">Derivated word forms</p>
~~-->
<!ELEMENT deriv (%inline;)* >
