<!--
   Modul für Literaturverweise gemäß Thieme Zeitschriften DTD
   Copyright (c) 2007-2015 Georg Thieme Verlag KG, Stuttgart
 -->

<!-- doc: Das Element kann alternativ zu `<literature> verwendet werden. Es erlaubt eine detaillierte und damit auch aufwändige Strukturierung der Literaturangaben.
Dieses Element wird bisher nur von der TReX-Formatvorlage für Zeitschriften unterstützt.-->
<!--~~ <litref>
<p lang="de">Das Element kann alternativ zu `<literature> verwendet werden. Es erlaubt eine detaillierte und damit auch aufwändige Strukturierung der Literaturangaben.
Dieses Element wird bisher nur von der TReX-Formatvorlage für Zeitschriften unterstützt.
Später soll die Auszeichnung weitestgehend automatisch erfolgen.</p>
<p lang="en">Alternative element to &lt;literature>. Allows a detailled but also more elaborate structure of the literature references.  Until now the element is only used for journals and the mark-up should later work automatically.</p>
~~-->
<!ELEMENT litref (jnref | bkref | chref | otherref) >

<!-- doc: Bildet die Klammer um eine Zeitschriftenreferenz-->
<!--~~ <jnref>
<p lang="de">Bildet die Klammer um eine Zeitschriftenreferenz</p>
<p lang="en">Brackets a journal reference</p>
~~-->
<!ELEMENT jnref	(((name | etal | anonymous | reftitle | refpub | date | volume | issue | supplement | fpage | lpage | uri | issn | txt)+, id* ) |(txt, id*))>
<!ATTLIST jnref
		id	ID	#REQUIRED
>

<!-- doc: Bildet die Klammer um eine Buchreferenz-->
<!--~~ <bkref>
<p lang="de">Bildet die Klammer um eine Buchreferenz</p>
<p lang="en">Brackets a book or e-book reference</p>
~~-->
<!ELEMENT bkref	(((name | etal| anonymous | reftitle | edition | location | pubname | date | series | volume | fpage | lpage |  uri | isbn | txt )+, id* ) | (txt, id*))>
<!ATTLIST bkref
		id	ID	#REQUIRED
>

<!-- doc: Bildet die Klammer um eine Kapitelreferenz-->
<!--~~ <chref>
<p lang="de">Bildet die Klammer um eine Kapitelreferenz</p>
<p lang="en">Brackets a chapter reference</p>
~~-->
<!ELEMENT chref	(((name | etal | anonymous | reftitle | refpub | edition | location | pubname | date | series | volume | fpage | lpage | uri | txt)+, id*) | (txt, id*))>
<!ATTLIST chref
		id	ID	#REQUIRED
>

<!-- doc: Bildet die Klammer um eine andere Referenz, z.B. Webseite, Patent, Konferenz-->
<!--~~ <otherref>
<p lang="de">Bildet die Klammer um eine andere Referenz, z.B. Webseite, Patent, Konferenz</p>
<p lang="en">Brackets another reference, e.g. website, patent, conference.</p>
~~-->
<!ELEMENT otherref (((name | etal | anonymous | reftitle | date | uri | patent | patentnr | txt)+, id* ) | (txt, id*))>
<!ATTLIST otherref
		id	ID	#REQUIRED
>

<!--  doc: Autorennamen, bestehend aus Nachname, Vornamen, Namenszusatz-->
<!--~~ <name>
<p lang="de">Autoren-, Herausgebernamen oder Name von Organisationen.
Anonyme Autoren werden seperat gekennzeichnet.
</p>
<p lang="en">Author, editor or company information. Anonymous authors gets marked with another element. 
</p>


~~ type
<p lang="de">author: Bestehend aus Nachname, Vornamen, Namenszusatz.<br/>
editor: Bestehend aus Nachname, Vornamen, Namenszusatz.<br/>
collab: Setzen Sie das Attribut @type auf "collab", wenn es sich beim dem Herausgeber um eine Organisation/ein Unternehmen handelt.</p>

<p lang="en">
author: Surname, Firstname, suffix.<br/>
editor: Surname, Firstname, suffix.<br/>
collab: Take "collab" in the attribute @type for referenced organisations or companys.</p>

~~-->
<!ELEMENT name (#PCDATA | lastname | firstname | suffix | personid )*>
<!ATTLIST name
   		 type  (author | editor | collab) #IMPLIED >

<!-- doc: Das Element zeichnet den Text "et al." für weitere, in der Referenz nicht aufgeführte Autoren/Herausgeber aus.-->
<!--~~ <etal>
<p lang="de">Das Element zeichnet den Text "et al." für weitere, in der Referenz nicht aufgeführte Autoren/Herausgeber aus. Im 3B2-Template wird der Standardtext "et al." eingefügt.</p>
<p lang="en">Brackets the text "et al." for not mentioned authors or editors in the reference. Text gets inserted in 3B2.</p>
~~-->
<!ELEMENT etal EMPTY> 

<!--~~ <anonymous>
<p lang="de">Das Element kennzeichnet anonyme Autoren. Im 3B2-Template wird der Standardtext "Anonym" eingefügt. </p>
<p lang="en">Brackets the text "Anonymous." for anonymous authors. Text gets inserted in 3B2.</p>
~~-->
<!ELEMENT anonymous EMPTY>


<!--~~ <reftitle>
<p lang="de">Titel der referenzierte Publikation (Artikel, Kapitel oder Buch).</p>
<p lang="en">Title of the referenced publication (article, chapter or book).</p>
~~-->
<!ELEMENT reftitle (#PCDATA | emph | sub | sup )*>
<!ATTLIST reftitle
        type (empty) #IMPLIED
>

<!-- doc: Name der Publikation, in der der Beitrag erschienen ist-->
<!--~~ <refpub>
<p lang="de">Name der Publikation, in der der Beitrag erschienen ist.</p>
<p lang="en">Name of the publication in which the reference occured.</p>
~~-->
<!ELEMENT refpub (#PCDATA | emph | sub | sup )*>

<!-- doc: Kennzeichnet einen Ort: Verlagsort oder Ort einer Veranstaltung-->
<!--~~ <location>
<p lang="de">Kennzeichnet einen Ort: Verlagsort oder Ort einer Veranstaltung.</p>
<p lang="en">Defines the location e.g. of the publishing house or of the conference.</p>
~~-->
<!ELEMENT location (#PCDATA)>

<!-- doc: Verlagsname-->
<!--~~ <pubname>
<p lang="de">Verlagsname</p>
<p lang="en">Name of the publishing house</p>
~~-->
<!ELEMENT pubname (#PCDATA)>

<!-- doc: Jahres-/Datumsangaben. Bitte im Format JJJJ-MM-TT. -->
<!--~~ <date>
<p lang="de">Jahres-/Datumsangaben. Bitte im Format JJJJ-MM-TT.</p>
<p lang="en">Date specification. Form: YYYY-MM-DD</p>
~~-->
<!ELEMENT date (#PCDATA)>

<!-- doc: Auflage eines Buches-->
<!--~~ <edition>
<p lang="de">Auflage eines Buches.</p>
<p lang="en">Edition of referenced book</p>
~~-->
<!ELEMENT edition (#PCDATA)>

<!-- doc: Ausgabe einer Zeitschrift-->
<!--~~ <issue>
<p lang="de">Ausgabe einer Zeitschrift.</p>
<p lang="en">Issue of a journal</p>
~~-->
<!ELEMENT issue (#PCDATA)>

<!-- doc: Supplementausgabe, Zeitschriftenbeilage, Sonderheft-->
<!--~~ <supplement>
<p lang="de">Supplementausgabe, Zeitschriftenbeilage, Sonderheft</p>
<p lang="en">Supplement</p>
~~-->
<!ELEMENT supplement (#PCDATA)>

<!-- doc: Erste Seite einer Referenz-->
<!--~~ <fpage>
<p lang="de">Erste Seite einer Referenz</p>
<p lang="en">First page of article</p>
~~-->
<!ELEMENT fpage (#PCDATA)>

<!-- doc: Letzte Seite einer Referenz-->
<!--~~ <lpage>
<p lang="de">Letzte Seite einer Referenz</p>
<p lang="en">Last page of article</p>
~~-->
<!ELEMENT lpage (#PCDATA)>
         
<!-- doc: Name eines Patents -->
<!--~~ <patent>
<p lang="de">Name eines Patents</p>
<p lang="en">Specification of the patent name</p>
~~-->
<!ELEMENT patent (#PCDATA)>

<!-- doc: Patentnummer-->
<!--~~ <patentnr>
<p lang="de">Patentnummer</p>
<p lang="en">Specification of the patent number</p>
~~-->
<!ELEMENT patentnr (#PCDATA)>

<!-- doc: Das Element beinhaltet entweder einen DOI, eine PubMed-ID oder eine Publisher-ID . Das muss als Wert im @type eingetragen werden.-->
<!--~~ <id>
<p lang="de">Das Element beinhaltet entweder einen DOI, eine PubMed-ID oder eine Publisher-ID. Das muss als Wert im @type eingetragen werden.</p>
<p lang="en">The element contains a DOI, a Pubmed-ID or Publisher-ID. This gets specified in the attribute @type.</p>

~~ type
<p lang="de">doi: DOI-ID;
pubmed: Pubmed-ID;
publisher-id: Publisher-ID</p>
<p lang="en">doi: DOI-ID;
pubmed: Pubmed-ID;
publisher-id: Publisher-ID</p>
~~-->
<!ELEMENT id (#PCDATA)>
<!ATTLIST id 
		type ( doi | pubmed | publisher-id) #REQUIRED
>
		
<!-- doc: Freitext. Bei nur teilstrukturierten Referenzen im <litref>.-->
<!--~~ <txt>
<p lang="de">Freitext. Bei nur teilstrukturierten Referenzen im `<litref>.</p>
<p lang="en">Free text for references, which are just partly structured in `<litref>.</p>
~~-->
<!ELEMENT txt (#PCDATA)>
